﻿using DevExpress.Xpo.DB;
using DevExpress.Xpo;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;
using XmlFiles;
using System.Net;
using System.IO;
using Datenbank.MSSQL;
using Datenbank.MSSQLI;
using Datenbank.MySQL;
using Datenbank.Access;
using Datenbank.DBAL;
using DevExpress.Xpo.Helpers;
using DevExpress.Xpo.DB.Helpers;

namespace k3WcfTerminal
{
    public class k3wcfService : CachedDataStoreService  //IDataStoreWarpService
    {
        static readonly Dictionary<Guid, IDataStore> expliciteDict = new Dictionary<Guid, IDataStore>();
        static private CDBAL dbConnectInit;
//        public static IDataStore DataStore;
        public static ICachedDataStore DataStore;
        //static readonly IDataStore mainDataStore;
        static readonly string connectionString;
        static private readonly string profileName;
        static private readonly SettingsFile settings;
        static readonly PersistentSettingFileReader psfReader;
        static k3wcfService()
        {
            ServicePointManager.ServerCertificateValidationCallback = delegate { return true; };
            ServicePointManager.SecurityProtocol = SecurityProtocolType.Ssl3 | SecurityProtocolType.Tls | SecurityProtocolType.Tls11 | SecurityProtocolType.Tls12;

            try
            {
                psfReader = new PersistentSettingFileReader();
            }
            catch (Exception ex) { }
            try
            {
                SettingsFileReader reader = new SettingsFileReader();
                settings = reader.GetSettingsFile(psfReader.GetProfileName());

                profileName = psfReader.GetProfileName();
            }
            catch (Exception ex) { }

            switch (settings.GetServerType())
            {
                case "SQLite":
                    //dbConnectInit = new SQLite(Path.Combine(Path.Combine(streamHelper.AssemblyDirectory, "data"), settings.GetDatabase()));
                    //webSession = new Session(dbConnectInit.dbSessionDL());
                    break;

                case "MSSQL":
                    if (settings.GetDbPort() == "1443")
                    {
                        dbConnectInit = new CMSSQL(settings.GetServerNameAlternative,
                               settings.GetDatabase(),
                               settings.GetDbUser(),
                               settings.GetDbPassword(),
                               settings.GetMediaDatabase(), settings.GetDbPort());
                    }
                    else
                    {
                        dbConnectInit = new CMSSQL(settings.GetServerNameAlternative,
                           settings.GetDatabase(),
                           settings.GetDbUser(),
                           settings.GetDbPassword(),
                           settings.GetMediaDatabase(), settings.GetDbPort());
                    }

                   // webSession = new Session(dbConnectInit.dbSessionDL());

                    // muss noch implementiert werden
                    break;

                case "MSSQLI":
                    if (settings.GetDbPort() == "1443")
                    {
                        dbConnectInit = new CMSSQLI(settings.GetServerNameAlternative,
                               settings.GetDatabase(),
                               settings.GetDbUser(),
                               settings.GetDbPassword(),
                               settings.GetMediaDatabase(), settings.GetDbPort());
                    }
                    else
                    {
                        dbConnectInit = new CMSSQLI(settings.GetServerNameAlternative,
                           settings.GetDatabase(),
                           settings.GetDbUser(),
                           settings.GetDbPassword(),
                           settings.GetMediaDatabase(), settings.GetDbPort());
                    }

                   // webSession = new Session(dbConnectInit.dbSessionDL());

                    // muss noch implementiert werden
                    break;

                case "MySQL":
                    try
                    {
                        if (settings.alternateAdress != null)
                        {

                            if (settings.alternateAdress != string.Empty)
                            {
                                Uri baseUri = new Uri(settings.alternateAdress);

                                IPHostEntry hostInfo = Dns.GetHostEntry(baseUri.Authority);
                                settings.GetServerNameAlternative = hostInfo.AddressList[0].ToString();
                            }
                            else
                            {
                                settings.GetServerNameAlternative = settings.GetServerName();
                            }
                        }
                        else
                        {
                            settings.GetServerNameAlternative = settings.GetServerName();
                        }
                        if (settings.GetDbPort().StartsWith("33"))
                        {
                            dbConnectInit = new CMySQL(settings.GetServerNameAlternative,
                            settings.GetDatabase(),
                            settings.GetDbUser(),
                            settings.GetDbPassword(),
                            settings.GetMediaDatabase(), settings.GetDbPort());
                        }
                        else
                        {
                            dbConnectInit = new CMySQL(settings.GetServerNameAlternative,
                           settings.GetDatabase(),
                           settings.GetDbUser(),
                           settings.GetDbPassword(),
                           settings.GetMediaDatabase(), settings.GetDbPort());
                        }
                        //dbConnectInit.UseInBlazorWithObjectSpaceClasses = true;
                        //webSession = new Session(dbConnectInit.dbSessionDL());
                    }
                    catch (Exception ex)
                    {
                        //XtraMessageBox.Show("Bei der Instanzierung der Datenbankklasse ist folgender Fehler aufgetreten: " + ex.Message);
                    }
                    break;

                case "Access":
                    //try
                    //{

                    //    if (settings.GetDBPath() != "")
                    //    {
                    //        dbConnectInit = new CAccess(settings.GetDatabase() + ".mdb",
                    //        settings.GetMediaDatabase() + ".mdb", settings.GetDBPath());
                    //    }
                    //    else
                    //    {
                    //        string Path1 = Path.Combine(streamHelper.AssemblyDirectory, settings.GetDatabase() + ".mdb");
                    //        if (!File.Exists(Path1))
                    //        {


                    //        }
                    //        dbConnectInit = new CAccess(settings.GetDatabase() + ".mdb",
                    //        settings.GetMediaDatabase() + ".mdb");
                    //    }

                    //}
                    //catch
                    //{
                    //   // XtraMessageBox.Show("Prerequisit Performance... (.mdb)");

                    //    dbConnectInit = new CAccess(settings.GetDatabase() + ".mdb",
                    //    settings.GetMediaDatabase() + ".mdb");

                    //    webSession = new Session(dbConnectInit.dbSessionDL(true));
                    //}
                    break;
                default:
                    break;

            }
           // string connectionString = MSSqlConnectionProvider.GetConnectionString(@"DESKTOP-MJTS56S\SQLEXPRESS", "ServiceDB");

            IDataStore dataStore = XpoDefault.GetConnectionProvider(dbConnectInit.XPOConnectionString, AutoCreateOption.DatabaseAndSchema);

            var dataCachingConfiguration = new DataCacheConfiguration();
            dataCachingConfiguration.Caching = DataCacheConfigurationCaching.All;
            DataCacheRoot dataCacheRoot = new DataCacheRoot(dataStore);
            dataCacheRoot.Configure(dataCachingConfiguration);
            DataStore = dataCacheRoot;
        }
        public k3wcfService()

            : base(DataStore)
        {
        }
        protected IDataStoreWarpService GetService(Guid clientId)
        {
            IDataStore expliciteDataStore;
            if (expliciteDict.TryGetValue(clientId, out expliciteDataStore))
            {
                return new DataStoreService(expliciteDataStore);
            }
            return new DataStoreService(DataStore);
        }

        private static Guid GetClientId()
        {
            //MessageHeader<String> tmpHeader1 = new MessageHeader<string>("woro:free");
            //OperationContext.Current.OutgoingMessageHeaders.Add(tmpHeader1.GetUntypedHeader("UserCreds", "urn:meheader.com"));

            string clientId1 = string.Empty;
            int Index1;
            Index1 = OperationContext.Current.IncomingMessageHeaders.FindHeader("UserCreds", "urn:meheader.com");
            if (Index1 >= 0)
            {
                clientId1 =  (OperationContext.Current.IncomingMessageHeaders.GetHeader<string>(Index1));
            }

            Guid clientId = Guid.Empty;
            int Index;
            Index = OperationContext.Current.IncomingMessageHeaders.FindHeader("MyHeader", "urn:meheader.com");
            if (Index >= 0)
            {
                clientId = new Guid(OperationContext.Current.IncomingMessageHeaders.GetHeader<string>(Index));
            }
            return clientId;
        }
        public OperationResult<object> Do(string command, object args)
        {
            if (command == CommandChannelHelper.Command_ExplicitBeginTransaction)
            {
                lock (expliciteDict)
                {
                    Guid clientId = GetClientId();
                    if (clientId != Guid.Empty)
                    {
                        expliciteDict[clientId] = XpoDefault.GetConnectionProvider(dbConnectInit.XPOConnectionString, AutoCreateOption.DatabaseAndSchema);
                    }
                    return GetService(clientId).Do(command, args);
                }
            }
            if (command == CommandChannelHelper.Command_ExplicitCommitTransaction || command == CommandChannelHelper.Command_ExplicitRollbackTransaction)
            {
                lock (expliciteDict)
                {
                    Guid clientId = GetClientId();
                    try
                    {
                        return GetService(clientId).Do(command, args);
                    }
                    finally
                    {
                        expliciteDict.Remove(clientId);
                    }
                }
            }
            return GetService(GetClientId()).Do(command, args);
        }
        public OperationResult<ModificationResult> ModifyData(ModificationStatement[] dmlStatements)
        {
            return GetService(GetClientId()).ModifyData(dmlStatements);
        }
        public OperationResult<SelectedData> SelectData(SelectStatement[] selects)
        {
            return GetService(GetClientId()).SelectData(selects);
        }
        public OperationResult<UpdateSchemaResult> UpdateSchema(bool dontCreateIfFirstTableNotExist, DBTable[] tables)
        {
            return GetService(GetClientId()).UpdateSchema(dontCreateIfFirstTableNotExist, tables);
        }
        public OperationResult<AutoCreateOption> GetAutoCreateOption()
        {
            return GetService(GetClientId()).GetAutoCreateOption();
        }
        public OperationResult<byte[]> WarpSelectData(SelectStatement[] selects)
        {
            return GetService(GetClientId()).WarpSelectData(selects);
        }

    }
}
